/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class InfoToken {
    private static Logger log = Logger.getLogger(InfoToken.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo;
                block9: {
                    resultatInfo = new ResultatInfo("Obtenir des informations sur la carte ");
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    resultatInfo.setInfos(linkedHashMap);
                    try {
                        if (resultatInfo == null) break block9;
                        CK_TOKEN_INFO cK_TOKEN_INFO = pKCS11.C_GetTokenInfo(l);
                        if (cK_TOKEN_INFO != null) {
                            resultatInfo.appendTraitement(new String(cK_TOKEN_INFO.label).trim() + " (C_GetTokenInfo)");
                            linkedHashMap.put("Libell\u00e9 application attribu\u00e9 lors de l'initialisation de la carte", new String(cK_TOKEN_INFO.label).trim());
                            linkedHashMap.put("Identifiant du fabricant de la carte", new String(cK_TOKEN_INFO.manufacturerID));
                            linkedHashMap.put("Mod\u00e8le de la carte", new String(cK_TOKEN_INFO.model));
                            linkedHashMap.put("Num\u00e9ro de s\u00e9rie de la carte", new String(cK_TOKEN_INFO.serialNumber));
                            linkedHashMap.put("Nombre maximum de sessions pouvant \u00eatre ouvertes simultan\u00e9ment par une m\u00eame application sur la carte", Long.toString(cK_TOKEN_INFO.ulMaxSessionCount));
                            linkedHashMap.put("Nombre de sessions que l'application courante a d'ouvertes sur la carte", Long.toString(cK_TOKEN_INFO.ulSessionCount));
                            linkedHashMap.put("Nombre maximum de sessions en lecture/\u00e9criture pouvant \u00eatre ouvertes simultan\u00e9ment par une m\u00eame application sur la carte", Long.toString(cK_TOKEN_INFO.ulMaxRwSessionCount));
                            linkedHashMap.put("Nombre de sessions en lecture/\u00e9criture que l'application courante a d'ouvertes sur la carte", Long.toString(cK_TOKEN_INFO.ulRwSessionCount));
                            linkedHashMap.put("Longueur maximale (en octets) du code porteur", Long.toString(cK_TOKEN_INFO.ulMaxPinLen));
                            linkedHashMap.put("Longueur minimale (en octets) du code porteur", Long.toString(cK_TOKEN_INFO.ulMinPinLen));
                            linkedHashMap.put("Capacit\u00e9 m\u00e9moire totale (en octets) pour le stockage d'objets publics", Long.toString(cK_TOKEN_INFO.ulTotalPublicMemory));
                            linkedHashMap.put("Espace m\u00e9moire disponible (en octets) pour le stockage d'objets publics", Long.toString(cK_TOKEN_INFO.ulFreePublicMemory));
                            linkedHashMap.put("Capacit\u00e9 m\u00e9moire totale (en octets) pour le stockage d'objets priv\u00e9s", Long.toString(cK_TOKEN_INFO.ulTotalPrivateMemory));
                            linkedHashMap.put("Espace m\u00e9moire disponible (en octets) pour le stockage d'objets priv\u00e9s", Long.toString(cK_TOKEN_INFO.ulFreePrivateMemory));
                            linkedHashMap.put("Num\u00e9ro de version mat\u00e9rielle de la carte", cK_TOKEN_INFO.hardwareVersion.toString());
                            linkedHashMap.put("Num\u00e9ro de version firmware de la carte", cK_TOKEN_INFO.firmwareVersion.toString());
                            if (new String(cK_TOKEN_INFO.utcTime).toString().trim().length() != 0) {
                                linkedHashMap.put("Date de la carte", new String(cK_TOKEN_INFO.utcTime));
                            } else {
                                linkedHashMap.put("Date de la carte", "indisponible");
                            }
                            linkedHashMap.put("La carte a son propre g\u00e9n\u00e9rateur de nombre al\u00e9atoire?", (cK_TOKEN_INFO.flags & 1L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte est-elle prot\u00e9g\u00e9e en \u00e9criture?", (cK_TOKEN_INFO.flags & 2L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte n\u00e9cessite-t-elle une authentification?", (cK_TOKEN_INFO.flags & 4L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Le code porteur de l'utilisateur est-il initialis\u00e9?", (cK_TOKEN_INFO.flags & 8L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La sauvegarde r\u00e9ussie de l'\u00e9tat d'une op\u00e9ration cryptographique de session contient-elle toutes les cl\u00e9s n\u00e9cessaires pour r\u00e9tablir l'\u00e9tat de la session?", (cK_TOKEN_INFO.flags & 0x20L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte poss\u00e8de-t-elle une horloge?", (cK_TOKEN_INFO.flags & 0x40L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte a-t-elle un mode d'authentification prot\u00e9g\u00e9 par o\u00f9 l'utilisateur peut s'authentifier sans passer de code porteur au travers d'une biblioth\u00e8que cryptographique?", (cK_TOKEN_INFO.flags & 0x100L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte permet-elle l'ex\u00e9cution d'op\u00e9rations cryptographiques \"dual\" lors d'une m\u00eame session?", (cK_TOKEN_INFO.flags & 0x200L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La carte est-elle initialis\u00e9e?", (cK_TOKEN_INFO.flags & 0x400L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Un code porteur utilisateur incorrect a-t-il \u00e9t\u00e9 saisi au moins une fois depuis la derni\u00e8re authentification utilisateur r\u00e9ussie?", (cK_TOKEN_INFO.flags & 0x10000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La prochaine saisie d'un code porteur utilisateur incorrect provoquera-t-elle le blocage du token?", (cK_TOKEN_INFO.flags & 0x20000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Le code porteur utilisateur est-il bloqu\u00e9?", (cK_TOKEN_INFO.flags & 0x40000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Le code porteur utilisateur doit-il \u00eatre chang\u00e9?", (cK_TOKEN_INFO.flags & 0x80000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Un code porteur Security Officer(SO) incorrect a-t-il \u00e9t\u00e9 saisi au moins une fois depuis la derni\u00e8re authentification SO r\u00e9ussie?", (cK_TOKEN_INFO.flags & 0x100000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("La prochaine saisie d'un code porteur SO incorrect provoquera-t-elle le blocage de la carte?", (cK_TOKEN_INFO.flags & 0x200000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Le code porteur SO est-il bloqu\u00e9?", (cK_TOKEN_INFO.flags & 0x400000L) != 0L ? "Oui" : "Non");
                            linkedHashMap.put("Le code porteur SO doit-il \u00eatre chang\u00e9?", (cK_TOKEN_INFO.flags & 0x800000L) != 0L ? "Oui" : "Non");
                            break block9;
                        }
                        resultatInfo.appendTraitement("(C_GetTokenInfo)");
                        log.error((Object)"L'operation a retourne des informations nulles");
                        throw new ExceptionTraitement(8, "L'op\u00e9ration a retourn\u00e9 des informations nulles");
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(8, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(8, "Une erreur inattendue est survenue");
        }
    }
}

